//Generate OR function with bipolar inputs and targets using Adaline network
//     Truth table for OR gate
//      X1    X2    Y
//      -1    -1    -1
//      -1     1     1
//       1    -1     1
//       1     1     1           (Bipolar   (1,-1))


clc;
clear;
disp('Adaline network for OR function Bipolar inputs and targets');
//input pattern
x1=[1 1 -1 -1];
x2=[1 -1 1 -1];
//bias pattern
x3=[1 1 1 1];
//target vector
t=[1 1 1 -1];
//initial weights and bias
w1=0.1;w2=0.1;b=0.1;
//initialize learning rate
alpha=0.1;
//error convergence
e=2;
//change in weights and bias
delw1=0;delw2=0;delb=0;
epoch=0;
while(e>1.018)
    epoch=epoch+1;
    e=0;
    for i=1:4
        nety(i)=w1*x1(i)+w2*x2(i)+b;
        //net input calculated and target
        nt=[nety(i) t(i)];
        delw1=alpha*(t(i)-nety(i))*x1(i);
        delw2=alpha*(t(i)-nety(i))*x2(i);
        delb=alpha*(t(i)-nety(i))*x3(i);
        //weight changes
        wc=[delw1 delw2 delb]
        //updating of weights
        w1=w1+delw1;
        w2=w2+delw2;
        b=b+delb;
        //new weights
        w=[w1 w2 b];
        //input pattern
        x=[x1(i) x2(i) x3(i)];
        //printing the results obtained
        disp([x nt wc w]);
    end
    for i=1:4
        nety(i)=w1*x1(i)+w2*x2(i)+b;
        e=e+(t(i)-nety(i))^2;
    end
    end
